//
//  MCPOptionsCache.h
//  MCFoundation
//
//  Created by Ali Lalani on 12/6/06.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

extern NSString *MCPOptionsCacheStaleTimeout;


@class MCPDatabaseObjectContext;
@interface MCPOptionsCache : NSObject {
	NSMutableDictionary *_optionsCache;
	NSMutableDictionary *_fetchDates;
	
	MCPDatabaseObjectContext    *_objectContext;
	
	NSTimeInterval      staleInterval;
}
- (id)initWithObjectContext:(MCPDatabaseObjectContext *)anObjectContext;

- (id)optionForKey:(NSString *)aKey primaryKeyValue:(NSNumber *)aValue;

// Just to check if the key exists or not in the config
- (BOOL)keyExists:(NSString *)aKey;
// if the option is derived, it will return the base key, otherwise it will return the key passed in (if it is a base key)
- (NSString *)baseKeyForKey:(NSString *)aKey;

#pragma mark CacheManagement
- (void)nullifyAllOptions;
- (void)nullifyOptionsForKey:(NSString *)aKey;
- (NSMutableArray *)optionsForKey:(NSString *)aKey;
- (NSMutableArray *)derivedOptionsForConfig:(NSDictionary *)aConfig;
- (void)addOption:(id)anObj forKey:(NSString *)aKey; // manually add an option, if for instance you have notifications turned off you may want to manage the cache yourself to add new objects

#pragma mark Accessors
- (NSMutableDictionary *)optionsCache;
- (void)setOptionsCache:(NSMutableDictionary *)anOptionsCache;

- (NSMutableDictionary *)fetchDates;
- (void)setFetchDates:(NSMutableDictionary *)aFetchDates;

- (MCPDatabaseObjectContext *)objectContext;
- (void)setObjectContext:(MCPDatabaseObjectContext *)anObjectContext;

@end
